/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.hooks;

import club.sk1er.patcher.config.PatcherConfig;
import java.awt.Dimension;
import java.awt.Toolkit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.Util;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;

public class MinecraftHook {
    public static final MinecraftHook INSTANCE = new MinecraftHook();
    private boolean lastFullscreen = false;

    private MinecraftHook() {
    }

    public static void updateKeyBindState() {
        for (KeyBinding keybinding : KeyBinding.field_74516_a) {
            try {
                KeyBinding.func_74510_a((int)keybinding.func_151463_i(), (keybinding.func_151463_i() < 256 && Keyboard.isKeyDown((int)keybinding.func_151463_i()) ? 1 : 0) != 0);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
    }

    public static boolean fullscreen() {
        if (!PatcherConfig.instantFullscreen || !PatcherConfig.windowedFullscreen || Util.func_110647_a() != Util.EnumOS.WINDOWS) {
            return false;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.field_71431_Q = !minecraft.field_71431_Q;
        boolean grabbed = Mouse.isGrabbed();
        if (grabbed) {
            Mouse.setGrabbed((boolean)false);
        }
        try {
            DisplayMode displayMode = Display.getDesktopDisplayMode();
            if (minecraft.field_71431_Q) {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
                Display.setDisplayMode((DisplayMode)displayMode);
                Display.setLocation((int)0, (int)0);
            } else {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
                displayMode = new DisplayMode(minecraft.field_71436_X, minecraft.field_71435_Y);
                Display.setDisplayMode((DisplayMode)displayMode);
                MinecraftHook.displayCommon();
            }
            Display.setFullscreen((boolean)false);
            minecraft.field_71443_c = displayMode.getWidth();
            minecraft.field_71440_d = displayMode.getHeight();
            if (minecraft.field_71462_r != null) {
                minecraft.func_71370_a(minecraft.field_71443_c, minecraft.field_71440_d);
            } else {
                minecraft.func_147119_ah();
            }
            MinecraftHook.INSTANCE.lastFullscreen = minecraft.field_71431_Q;
            minecraft.func_175601_h();
            Mouse.setCursorPosition((int)((Display.getX() + Display.getWidth()) / 2), (int)((Display.getY() + Display.getHeight()) / 2));
            if (grabbed) {
                Mouse.setGrabbed((boolean)true);
            }
            Display.setResizable((boolean)false);
            Display.setResizable((boolean)true);
            return true;
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void displayCommon() {
        Display.setResizable((boolean)false);
        Display.setResizable((boolean)true);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)Display.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)Display.getHeight()) / 2.0);
        Display.setLocation((int)x, (int)y);
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !PatcherConfig.windowedFullscreen) {
            return;
        }
        boolean fullScreenNow = Minecraft.func_71410_x().func_71372_G();
        if (this.lastFullscreen != fullScreenNow) {
            this.fix(fullScreenNow);
            this.lastFullscreen = fullScreenNow;
        }
    }

    public void fix(boolean fullscreen) {
        try {
            if (fullscreen) {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "true");
                Display.setDisplayMode((DisplayMode)Display.getDesktopDisplayMode());
                Display.setLocation((int)0, (int)0);
                Display.setFullscreen((boolean)false);
            } else {
                System.setProperty("org.lwjgl.opengl.Window.undecorated", "false");
                Display.setDisplayMode((DisplayMode)new DisplayMode(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d));
                MinecraftHook.displayCommon();
            }
            Display.setResizable((!fullscreen ? 1 : 0) != 0);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }
}

